@extends('layouts.app')
@section('css')
@endsection
@section('content')
    <!-- begin breadcrumb -->
    <ol class="breadcrumb float-xl-right">
        <li class="breadcrumb-item"><a href="javascript:;">SGD</a></li>
        <li class="breadcrumb-item active">Dashboard</li>
    </ol>
    <!-- end breadcrumb -->
    <!-- begin page-header -->
    <h1 class="page-header">Dashboard <small> detalles generales sobre tus documentos</small></h1>
    <!-- end page-header -->

    <!-- begin row -->
    <div class="row">
        @if (auth()->check() && auth()->user()->isTrabajador() && Auth::user()->oficina->tipo_oficina == 'BUZON')
            <!-- begin col-3 -->
            <div class="col-xl-3 col-md-6">
                <div class="widget widget-stats bg-info">
                    <div class="stats-icon stats-icon-lg"><i class="fa fa-globe fa-fw"></i></div>
                    <div class="stats-content">
                        <div class="stats-title">EXPEDIENTES VIRTUALES</div>
                        <div id="count_virtuales_" class="stats-number">0</div>

                    </div>
                </div>
            </div>
            <!-- end col-3 -->
        @endif

        <!-- begin col-3 -->
        <div class="col-xl-3 col-md-6">
            <div class="widget widget-stats bg-warning">
                <div class="stats-icon stats-icon-lg"><i class="fa fa-globe fa-fw"></i></div>
                <div class="stats-content">
                    <div class="stats-title">EXPEDIENTES PENDIENTES</div>
                    <div id="count_pendientes_" class="stats-number">0</div>

                </div>
            </div>
        </div>
        <!-- end col-3 -->
        <!-- begin col-3 -->
        <div class="col-xl-3 col-md-6">
            <div class="widget widget-stats bg-teal">
                <div class="stats-icon stats-icon-lg"><i class="fa fa-calculator fa-fw"></i></div>
                <div class="stats-content">
                    <div class="stats-title">EXPEDIENTES ACEPTADOS</div>
                    <div id="count_aceptados_" class="stats-number">0</div>

                </div>
            </div>
        </div>
        <!-- end col-3 -->
        <!-- begin col-3 -->
        <div class="col-xl-3 col-md-6">
            <div class="widget widget-stats bg-indigo">
                <div class="stats-icon stats-icon-lg"><i class="fa fa-archive fa-fw"></i></div>
                <div class="stats-content">
                    <div class="stats-title">EXPEDIENTES FINALIZADOS</div>
                    <div id="count_finalizados_" class="stats-number">0</div>

                </div>
            </div>
        </div>
        <!-- end col-3 -->
        <!-- begin col-3 -->
        <div class="col-xl-3 col-md-6">
            <div class="widget widget-stats bg-dark">
                <div class="stats-icon stats-icon-lg"><i class="fa fa-comment-alt fa-fw"></i></div>
                <div class="stats-content">
                    <div class="stats-title">CARGOS</div>
                    <div id="count_cargos_" class="stats-number">0</div>


                </div>
            </div>
        </div>
        <!-- end col-3 -->
    </div>
    <!-- end row -->
@endsection
@section('js')
    <script>
        load_count_();

        function load_count_() {
            var csrfToken = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                "url": "/load-count",
                type: 'POST',
                data: {
                    _token: csrfToken,
                }
            }).done(function(response) {
                let data = response['data'];
                if (response['type'] == '1') {

                    document.getElementById('count_pendientes_').innerHTML = response['count_bandeja'];
                    document.getElementById('count_aceptados_').innerHTML = response['count_aceptados'];
                    document.getElementById('count_finalizados_').innerHTML = response['count_finalizados'];
                    document.getElementById('count_cargos_').innerHTML = response['count_cargos'];

                } else if (response['type'] == '2') {
                    document.getElementById('count_pendientes_').innerHTML = response['count_bandeja'];
                    document.getElementById('count_aceptados_').innerHTML = response['count_aceptados'];
                    document.getElementById('count_finalizados_').innerHTML = response['count_finalizados'];
                    document.getElementById('count_cargos_').innerHTML = response['count_cargos'];
                    document.getElementById('count_virtuales_').innerHTML = response['count_virtuales'];

                } else if (response['type'] == '3') {
                    document.getElementById('count_areas').innerHTML = response['count_areas'];
                    document.getElementById('count_oficinas').innerHTML = response['count_oficinas'];
                    document.getElementById('count_empleados').innerHTML = response['count_empleados'];

                    document.getElementById('count_tipos').innerHTML = response['count_tipos'];
                    document.getElementById('count_cuentas').innerHTML = response['count_cuentas'];
                    document.getElementById('count_tupas').innerHTML = response['count_tupas'];

                }


            });
        }
    </script>
@endsection
