@extends('layouts.app')
@section('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap-5-theme.min.css') }}" />
    <style>
        .select2-selection__arrow {
            display: none !important;
        }

        label {
            font-weight: bolder;
        }

        /* Define el color de fondo deseado para cuando haya texto */
        .bg-color {
            background-color: lemonchiffon !important;
            /* Cambia esto al color que prefieras */
        }
        .bg-color:focus{
            background-color: lemonchiffon;
        }
        .bg-color:not(:placeholder-shown){
            background-color: lemonchiffon;
        }
        .bg-color:valid{
            background-color: lemonchiffon;
        }
        .select2-container--bootstrap-5 .select2-selection{
            background-color: lemonchiffon;
        }

        
    </style>
@endsection
@section('content')
    <!-- begin breadcrumb -->
    <ol class="breadcrumb float-xl-right">
        <li class="breadcrumb-item"><a href="javascript:;">SGD</a></li>
        <li class="breadcrumb-item"><a href="javascript:;">Registrar expediente</a></li>
        <li class="breadcrumb-item active">Formulario interno</li>
    </ol>
    <!-- end breadcrumb -->
    <!-- begin page-header -->
    <h1 class="page-header">Formulario de registro de expedientes físicos <small></small></h1>
    <!-- end page-header -->
    <!-- begin row -->

    <div class="row " style="background-color: white">
        <div class="col-lg-6" style="padding:inherit;">
            <div class="panel panel-default m-0 p-0">

                <div class="panel-heading">
                    <h4 class="panel-title font-weight-bolder">DATOS DEL DOCUMENTO</h4>

                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12 mb-4">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="customCheck1">
                                <label class="custom-control-label" for="customCheck1">Generar número automáticamente</label>
                              </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <label class=" font-weight-bolder">Asignar un número de expediente <span
                                    class=" text-danger">*</span> </label>
                            <div class="row row-space-10">
                                <div class="col-md-6 m-b-15">
                                    <input type="number" id="numero_expediente" class="bg-color form-control"
                                        placeholder="Número" required="">
                                </div>
                                <div class="col-md-6 m-b-15">
                                    <input type="text" value="{{ date('Y') }}" class="form-control bg-color" disabled>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Cabecera del documento<span class=" text-danger">*</span> </label>
                            <input class="bg-color form-control myi" type="text" id="cabecera_documento"
                                placeholder="Deshabilitado" disabled>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <label>Asunto<span class=" text-danger">*</span> </label>
                            <textarea id="asunto_documento" rows="3" class="bg-color form-control myi" style="resize:none;"
                                ></textarea>
                                <div class="sugerencias mt-2" id="sugerencias_asunto"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6 mb-3">
                            <label class="control-label">Tipo de documento <span class="text-danger">*</span></label>
                            <select class="form-select bg-color" id="tipo_documento">

                            </select>
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Número<span class=" text-danger">*</span> </label>
                            <input class="form-control bg-color" value="S/N" type="text" id="numero_documento"
                                placeholder="S/N">
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Folios<span class=" text-danger">*</span> </label>
                            <input class="form-control bg-color" type="number" id="folios_documento" placeholder="Páginas">
                        </div>



                    </div>

                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <label>Adjuntar documento (PDF)<span class=" text-danger">*</span> </label>
                            <input id="archivo_documento" type="file" class="form-control bg-color" accept="application/pdf">
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <div class="col-lg-6" style="padding:inherit;">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h4 class="panel-title font-weight-bolder">DATOS DEL SOLICITANTE</h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-6 mb-3">
                            <label class="control-label">Tipo de persona <span class="text-danger">*</span></label>
                            <select class="form-select bg-color" id="tipo_persona">
                                <option value=""></option>
                                <option value="PERSONA NATURAL">PERSONA NATURAL</option>
                                <option value="PERSONA JURIDICA">PERSONA JURIDICA</option>
                            </select>
                        </div>

                    </div>
                    <div id="inputs" class="row" style="display: none">
                        <div class="col-lg-4 mb-3">
                            <label>Número de RUC<span class=" text-danger">*</span> </label>
                            <input class="form-control myi bg-color" type="text" id="ruc"
                                placeholder="Ingrese el RUC  del la entidad">
                        </div>
                        <div class="col-lg-8 mb-3">
                            <label>Razón Social<span class=" text-danger">*</span> </label>
                            <input class="form-control myi bg-color" type="text" id="razon"
                                placeholder="Ingrese el nombre de la entidad">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6 mb-3">
                            <label>Nombres<span class=" text-danger">*</span> </label>
                            <input class="form-control myi bg-color" type="text" id="nombre"
                                placeholder="Ingrese su nombre">
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Documento de identidad<span class=" text-info"> (Opcional)</span> </label>
                            <div class="input-group">
                                <input id="dni" type="text" class="form-control bg-color" placeholder="Escriba su DNI">
                                <span class="input-group-append">
                                    <button id="buscar_dni_api"type="button" class="btn btn-inverse">Buscar</button>
                                </span>
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Apellido paterno<span class=" text-danger">*</span> </label>
                            <input class="form-control myi bg-color" type="text" id="paterno"
                                placeholder="Ingrese su apellido paterno">
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Apellido materno<span class=" text-danger">*</span> </label>
                            <input class="form-control myi bg-color" type="text" id="materno"
                                placeholder="Ingrese su apellido materno">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <label>Dirección<span class=" text-info"> (Opcional)</span> </label>
                            <input class="form-control myi bg-color" type="text" id="direccion"
                                placeholder="Ingrese su dirección">
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Correo electrónico<span class=" text-info"> (Opcional)</span> </label>
                            <input class="form-control bg-color" type="text" id="correo"
                                placeholder="Ingrese su correo electrónico">
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Celular / Teléfono<span class=" text-info"> (Opcional)</span> </label>
                            <input class="form-control bg-color" type="text" id="celular"
                                placeholder="Ingrese su número teléfonico">
                        </div>
                        <label for="" class="text-dark">(<span class="text-danger">*</span>) Indica que los
                            campos son obligatorios</label>
                    </div>
                </div>

            </div>
        </div>

        <div class="col-lg-12 mb-3">
            <div class="register-buttons text-center">
                <button id="registrar" type="button" class="btn btn-success"><i
                        class="fas mr-1 fa-paper-plane"></i>Registrar expediente</button>
            </div>

        </div>
    </div>

    <!-- end row -->

    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_ver_cargo">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Cargo</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-sm-12">

                            <iframe id="documento_doc_cargo" width="100%" height="500" src=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
@endsection
@section('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('js/registrar-expediente.js') }}"></script>
    <script>
        $('#tipo_persona').select2({
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#tipo_documento').select2({
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#area_edit').select2({
            dropdownParent: '#modal_editar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        });
       /* document.addEventListener("DOMContentLoaded", function() {
            const inputs = document.querySelectorAll('input');
            inputs.forEach(input => {
                input.removeAttribute('placeholder');
            });
        });*/

        document.addEventListener('DOMContentLoaded', function() {
    var sugerenciasContainer = document.getElementById('sugerencias_asunto');
    var asuntoInput = document.getElementById('asunto_documento');
    var registrarButton = document.getElementById('registrar');

    // Mostrar sugerencias mientras el usuario escribe
    asuntoInput.addEventListener('input', function() {
        mostrarSugerencias();
    });

    // Guardar el asunto al hacer clic en el botón "Registrar expediente"
    registrarButton.addEventListener('click', function() {
        guardarAsunto();
    });

    function mostrarSugerencias() {
        var asunto = asuntoInput.value.trim();
        sugerenciasContainer.innerHTML = ''; // Limpiar las sugerencias anteriores
        
        if (asunto !== '') {
            // Obtener sugerencias guardadas del localStorage
            var sugerenciasGuardadas = localStorage.getItem('sugerencias') ? JSON.parse(localStorage.getItem('sugerencias')) : [];
            
            // Filtrar sugerencias basadas en lo que el usuario ha escrito
            var sugerenciasFiltradas = sugerenciasGuardadas.filter(function(sugerencia) {
                return sugerencia.toLowerCase().includes(asunto.toLowerCase());
            });
            
            // Mostrar las sugerencias filtradas
            sugerenciasFiltradas.forEach(function(sugerencia) {
                var sugerenciaElement = document.createElement('a');
                sugerenciaElement.textContent = sugerencia;
                sugerenciaElement.classList.add('sugerencia');
                sugerenciaElement.href = '#';
                sugerenciaElement.addEventListener('click', function(event) {
                    event.preventDefault(); // Evitar que el hipervínculo redirija
                    asuntoInput.value = sugerencia;
                    sugerenciasContainer.style.display = 'none';
                });
                sugerenciasContainer.appendChild(sugerenciaElement);
                sugerenciasContainer.appendChild(document.createElement('br')); // Añadir un salto de línea
            });

            // Mostrar el contenedor de sugerencias
            sugerenciasContainer.style.display = 'block';
        } else {
            // Ocultar el contenedor de sugerencias si el campo está vacío
            sugerenciasContainer.style.display = 'none';
        }
    }

    function guardarAsunto() {
        var asunto = asuntoInput.value.trim();
        if (asunto !== '') {
            // Obtener sugerencias guardadas anteriormente
            var sugerenciasGuardadas = localStorage.getItem('sugerencias') ? JSON.parse(localStorage.getItem('sugerencias')) : [];
            
            // Verificar si el asunto ya existe en las sugerencias guardadas
            if (!sugerenciasGuardadas.includes(asunto)) {
                // Agregar el nuevo asunto a las sugerencias guardadas
                sugerenciasGuardadas.push(asunto);
                // Guardar las sugerencias actualizadas en el almacenamiento local
                localStorage.setItem('sugerencias', JSON.stringify(sugerenciasGuardadas));
            }
        }
    }
});

    </script>
@endsection
