@extends('layouts.app')
@section('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap-5-theme.min.css') }}" />
    <style>
        .select2-selection__arrow {
            display: none !important;
        }
    </style>
@endsection
@section('content')
    <!-- begin breadcrumb -->
    <ol class="breadcrumb float-xl-right">
        <li class="breadcrumb-item"><a href="javascript:;">SGD</a></li>
        <li class="breadcrumb-item"><a href="javascript:;">Buscar</a></li>
        <li class="breadcrumb-item active">Seguimiento expediente</li>
    </ol>
    <!-- end breadcrumb -->
    <!-- begin page-header -->
    <h1 class="page-header">Busqueda de expedientes </h1>
    <!-- end page-header -->
    <!-- begin row -->

    <div class="row">

        <!-- begin col-10 -->
        <div class="col-xl-12">
            <!-- begin panel -->
            <div class="panel panel-inverse">
                <!-- begin panel-heading -->
                <div class="panel-heading">
                    <h4 class="panel-title">Datos - Expediente</h4>

                </div>
                <!-- end panel-heading -->

                <!-- begin panel-body -->
                <div class="panel-body">

                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <div class="custom-control custom-radio mb-1">
                                <input value="1" checked type="radio" id="customRadio1" name="customRadio"
                                    class="custom-control-input">
                                <label class="custom-control-label" for="customRadio1">Buscar por número de
                                    expediente</label>
                            </div>
                            <div class="custom-control custom-radio mb-1">
                                <input value="2" type="radio" id="customRadio2" name="customRadio"
                                    class="custom-control-input">
                                <label class="custom-control-label" for="customRadio2">Buscar por CUT</label>
                            </div>


                        </div>
                    </div>
                    <div class="row">
                        <div id="buscar_numero" class="col-lg-4 mb-3">
                            <label>Número de Expediente <span class=" text-danger"></span> </label>
                            <input class="form-control" type="text" id="numero_expediente">
                        </div>
                        <div id="buscar_codigo" class="col-lg-4 mb-3" style="display: none;">
                            <label>Código de Registro<span class=" text-danger"></span> </label>
                            <input class="form-control" type="text" id="codigo_expediente">
                        </div>

                        <div class="col-lg-4 mb-3">
                            <label>Año de Expediente <span class=" text-danger">*</span> </label>
                            <select class="form-select" id="anio">
                                <option value=""></option>
                                @for ($i = date('Y'); $i >= 2024; $i--)
                                    <option value="{{ $i }}">{{ $i }}</option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label><span class=" text-white">*</span> </label>
                            <button id="buscar_expediente" class="btn btn-success form-control">Buscar</button>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-lg-12">
                            <h5>DATOS DEL EXPEDIENTE</h5>

                        </div>
                        <div class="col-lg-12">
                            <table id="tabla_expedientes" class="w-100 table table-striped table-bordered table-td-valign-middle">
                                <thead>
                                    <tr>
                                        <th width="1%">#</th>
                                        <th class="text-nowrap">N° de expediente</th>
                                        <th class="text-nowrap">Tipo de persona</th>
                                        <th style="width: 89px" class="text-nowrap">Mas datos</th>
                                        <th class="text-nowrap">Tipo de documento</th>
                                        <th class="text-nowrap">Asunto</th>
                                        <th class="text-nowrap">Fecha registro</th>
                                        <th class="text-nowrap">Oficina Actual</th>
                                        <th class="text-nowrap">Estado</th>
                                        <th class="text-nowrap">Mov.</th>
                                    </tr>
                                </thead>
        
                                <tbody>
        
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th width="1%">#</th>
                                        <th class="text-nowrap">N° de expediente</th>
                                        <th class="text-nowrap">Tipo de persona</th>
                                        <th class="text-nowrap">Mas datos</th>
                                        <th class="text-nowrap">Tipo de documento</th>
                                        <th class="text-nowrap">Asunto</th>
                                        <th class="text-nowrap">Fecha registro</th>
                                        <th class="text-nowrap">Oficina Actual</th>
                                        <th class="text-nowrap">Estado</th>
                                        <th class="text-nowrap">Movimientos</th>
                                    </tr>
                                </tfoot>
        
                            </table>

                        </div>

                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-lg-6 mb-3">
                            <h5>RUTA DEL EXPEDIENTE</h5>

                        </div>
                        <div class="col-lg-6 text-right mb-3">
                            <button id="generar_ruta" class="btn btn-success"><i
                                    class="fas fa-lg fa-fw m-r-1 fa-download"></i> Descargar Hoja
                                de
                                Ruta</button>

                        </div>
                        <div class="col-lg-12">

                            <table id="tabla_ruta" class="w-100 table table-striped table-bordered table-td-valign-middle">
                                <thead>
                                    <tr>
                                        <th width="1%">#</th>
                                        <th class="text-nowrap">Nro de Registro</th>
                                        <th class="text-nowrap">Oficina</th>
                                        <th class="text-nowrap">Responsable</th>
                                        <th class="text-nowrap">Estado / Acción</th>
                                        <th class="text-nowrap">Fecha</th>
                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th width="1%">#</th>
                                        <th class="text-nowrap">Nro de Registro</th>
                                        <th class="text-nowrap">Oficina</th>
                                        <th class="text-nowrap">Responsable</th>
                                        <th class="text-nowrap">Estado / Acción</th>
                                        <th class="text-nowrap">Fecha</th>
                                    </tr>
                                </tfoot>

                            </table>
                        </div>

                    </div>

                </div>
                <!-- end panel-body -->
            </div>
            <!-- end panel -->
        </div>
        <!-- end col-10 -->

    </div>

    <!-- end row -->

    
    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_remitente">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Datos del remitente</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="control-label">Tipo de persona <span class="text-danger"></span></label>
                            <div class="input-group">
                                <input id="tipo_persona" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>RUC<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="ruc" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>Razón social<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="razon" type="text" class="form-control" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6 mb-3">
                            <label>Documento de identidad<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="dni" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Nombres<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="nombre" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Apellido paterno<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="paterno" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Apellido materno<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="materno" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label>Dirección<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="direccion" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Correo electrónico<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="correo" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Teléfono / Celular<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="celular" type="text" class="form-control">
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->

    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_documento">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Datos del documento</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="control-label">Tipo de documento <span class="text-danger"></span></label>
                            <div class="input-group">
                                <input id="tipo_documento_mas" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Numero<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="numero_documento_mas" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Folios<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="folios_documento_mas" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>Cabecera<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="cabecera_documento_mas" type="text" class="form-control" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <span id="lbl_documento_mas"></span>
                            <iframe id="documento_doc_mas" width="100%" height="500" src=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_cargo">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Cargo</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">


                    <div class="row">
                        <div class="col-sm-12">

                            <iframe id="documento_doc_cargo_or" width="100%" height="500" src=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
    <!-- #modal-dialog -->
    <div class="modal fade " id="modal_tbl_ruta">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Trayectoria del expediente</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <table id="tabla_movimiento"
                                class="table table-striped table-bordered table-td-valign-middle">
                                <thead>
                                    <tr>
                                        <th width="1%">#</th>
                                        <th class="text-nowrap">Unidad Orgánica</th>
                                        <th class="text-nowrap">Responsable</th>
                                        <th class="text-nowrap">Nro Registro</th>
                                        <th class="text-nowrap">Año</th>
                                        <th class="text-nowrap">Estado</th>
                                        <th class="text-nowrap">Fecha</th>
                                        <th class="text-nowrap">Mas datos</th>
                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th width="1%">#</th>
                                        <th class="text-nowrap">Unidad Orgánica</th>
                                        <th class="text-nowrap">Responsable</th>
                                        <th class="text-nowrap">Nro Registro</th>
                                        <th class="text-nowrap">Año</th>
                                        <th class="text-nowrap">Estado</th>
                                        <th class="text-nowrap">Fecha</th>
                                        <th class="text-nowrap">Mas datos</th>
                                    </tr>
                                </tfoot>
                            </table>

                        </div>

                    </div>

                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->

    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_movimiento">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Datos del movimiento del expediente</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <ul class="nav nav-pills mb-2">
                        <li class="nav-item">
                            <a href="#nav-pills-tab-1" data-toggle="tab" class="nav-link active">
                                <span class="d-sm-none">Ver Información</span>
                                <span class="d-sm-block d-none">Ver Información</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#nav-pills-tab-2" data-toggle="tab" class="nav-link">
                                <span class="d-sm-none">Ver Documento</span>
                                <span class="d-sm-block d-none">Ver Documento</span>
                            </a>
                        </li>

                    </ul>
                    <div class="tab-content p-15 rounded bg-white mb-4">
                        <!-- begin tab-pane -->
                        <div class="tab-pane fade active show" id="nav-pills-tab-1">
                            <div class="row">
                                <div class="col-lg-4 mb-3">
                                    <label class="control-label">Tipo de documento <span
                                            class="text-danger"></span></label>
                                    <div class="input-group">
                                        <input id="tipo_documento_mov" type="text" class="form-control" disabled>
                                    </div>
                                </div>
                                <div class="col-lg-2 mb-3">
                                    <label>Numero<span class=" text-danger"></span> </label>
                                    <div class="input-group">
                                        <input id="numero_documento_mov" type="text" class="form-control" disabled>
                                    </div>
                                </div>
                                <div class="col-lg-2 mb-3">
                                    <label>Folios<span class=" text-danger"></span> </label>
                                    <div class="input-group">
                                        <input id="folios_documento_mov" type="text" class="form-control" disabled>
                                    </div>
                                </div>
                                <div class="col-lg-4 mb-3">
                                    <label>Cabecera<span class=" text-danger"></span> </label>
                                    <div class="input-group">
                                        <input id="cabecera_documento_mov" type="text" class="form-control" disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12 mb-3">
                                    <label>Asunto<span class=" text-danger"></span> </label>
                                    <textarea id="asunto_documento_mov" rows="3" class="form-control" style="resize:none;" disabled></textarea>

                                </div>
                            </div>
                        </div>
                        <!-- end tab-pane -->
                        <!-- begin tab-pane -->
                        <div class="tab-pane fade" id="nav-pills-tab-2">
                            <div class="row">
                                <div class="col-sm-12">
                                    <span id="lbl_documento_mov"></span>

                                    <iframe style="display: none" id="documento_doc_mov" width="100%" height="500"
                                        src=""></iframe>

                                </div>
                            </div>
                        </div>
                        <!-- end tab-pane -->
                        <!-- begin tab-pane -->

                    </div>

                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->

      <!-- #modal-dialog -->
      <div class="modal fade" id="modal_ver_hoja_ruta">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Cargo de registro</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-sm-12">

                            <iframe id="documento_doc_hoja_ruta" width="100%" height="500"
                                src=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
@endsection
@section('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('js/buscar.js') }}"></script>
    <script>
        $('#anio').select2({

            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
    </script>
@endsection
