@extends('layouts.app')
@section('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap-5-theme.min.css') }}" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <style>
        .select2-selection__arrow {
            display: none !important;
        }

        label {
            font-weight: bolder;
        }

        /* Define el color de fondo deseado para cuando haya texto */
        .bg-color {
            background-color: lemonchiffon !important;
            /* Cambia esto al color que prefieras */
        }

        .bg-color:focus {
            background-color: lemonchiffon;
        }

        .select2-container--bootstrap-5 .select2-selection {
            background-color: lemonchiffon;
        }
    </style>
@endsection
@section('content')
    <!-- begin breadcrumb -->
    <ol class="breadcrumb float-xl-right">
        <li class="breadcrumb-item"><a href="javascript:;">SGD</a></li>
        <li class="breadcrumb-item"><a href="javascript:;">Aceptados</a></li>
        <li class="breadcrumb-item active">Expedientes aceptados</li>
    </ol>
    <!-- end breadcrumb -->
    <!-- begin page-header -->
    <h1 class="page-header">Lista de expedientes aceptados <small></small></h1>
    <!-- end page-header -->
    <!-- begin row -->

    <div class="row">

        <!-- begin col-10 -->
        <div class="col-xl-12">
            <!-- begin panel -->
            <div class="panel panel-inverse">
                <!-- begin panel-heading -->
                <div class="panel-heading">
                    <h4 class="panel-title">Lista de expedientes aceptados</h4>

                </div>
                <!-- end panel-heading -->

                <!-- begin panel-body -->
                <div class="panel-body table-responsive">
                    <div class="btn-group mb-3">
                        <button id="derivar_varios_box" class="btn btn-white"><i
                                class="fas fa-lg fa-fw m-r-1 fa-sign-out-alt"></i>Derivar Varios</button>
                        <button id="finalizar_varios_box" class="btn btn-white"><i
                                class="fas fa-lg fa-fw m-r-1 fa-calendar-check"></i>Finalizar Varios</button>
                        <button id="archivar_varios_box" class="btn btn-white"><i
                                class="fas fa-lg fa-fw m-r-1 fa-briefcase"></i> Archivar Varios</button>
                    </div>
                    
                    <table id="tabla_expedientes" class="w-100 table table-striped table-bordered table-td-valign-middle">
                        <thead>
                            <tr>
                                <th width="1%">#</th>
                                <th width="1%"></th>
                                <th class="text-nowrap">N° Reg. Int.</th>
                                <th class="text-nowrap">N° de Exp.</th>
                                <th style="width: 89px" class="text-nowrap">Mas datos</th>
                                <th class="text-nowrap">Asunto</th>
                                <th class="text-nowrap">Fecha registro</th>
                                <th class="text-nowrap">Procedencia</th>
                                <th class="text-nowrap">Estado</th>
                                <th class="text-nowrap">Acciones</th>
                            </tr>
                        </thead>

                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <th width="1%">#</th>
                                <th width="1%"></th>
                                <th class="text-nowrap">N° Reg. Int.</th>
                                <th class="text-nowrap">N° de Exp.</th>
                                <th style="width: 89px" class="text-nowrap">Mas datos</th>
                                <th class="text-nowrap">Asunto</th>
                                <th class="text-nowrap">Fecha registro</th>
                                <th class="text-nowrap">Procedencia</th>
                                <th class="text-nowrap">Estado</th>
                                <th class="text-nowrap">Acciones</th>
                            </tr>
                        </tfoot>

                    </table>
                </div>
                <!-- end panel-body -->
            </div>
            <!-- end panel -->
        </div>
        <!-- end col-10 -->
    </div>


    <!-- end row -->

    <!-- #modal-dialog -->
    <div class="modal fade " id="modal_derivar_expediente" data-backdrop="static" data-keyboard="false" tabindex="-1"
        aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Acciones de movimiento simple del documento</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-6 mb-3">
                            <label>Acción <span class=" text-danger">*</span> </label>
                            <select class="form-select" id="accion">
                                <option value=""></option>
                                <option value="DERIVAR">DERIVAR</option>
                                <option value="FINALIZAR">FINALIZAR</option>
                                <option value="ARCHIVAR">ARCHIVAR</option>
                            </select>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-lg-5 mb-3">
                            <label>Oficina destino <span class=" text-danger">*</span> </label>
                            <select class="form-select" id="destino" disabled>

                            </select>
                        </div>
                        <div class="col-lg-7 mb-3">
                            <label>Destinatario <span class=" text-danger">*</span> </label>
                            <select class="form-select" id="empleado" disabled>

                            </select>
                        </div>

                    </div>
                   
                    <input type="text" id="id_edit" hidden>
                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="control-label">Tipo de documento <span class="text-danger">*</span></label>
                            <select class="form-select" id="tipo_documento" disabled>

                            </select>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Núm.<span class=" text-info"> (Opcional)</span> </label>
                            <input class="form-control " type="text" id="numero_documento" placeholder="S/N"
                                disabled>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Folios<span class=" text-info"> (Opcional)</span> </label>
                            <input class="form-control" type="number" id="folios_documento" placeholder="Páginas"
                                disabled>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>Cabecera del documento<span class=" text-info"> (Opcional)</span></label>
                            <input disabled class="form-control myi" type="text" id="cabecera_documento"
                                placeholder="Ejemplo: OFICIO Nº 037-2024-ME-DREP-UGEL-Y/DIES “DAC”-Q">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 mb-3" id="box_cargar_data" style="display: none">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="customCheck1">
                                <label class="custom-control-label text-indigo" for="customCheck1">Cargar datos del
                                    documento principal</label>
                            </div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label>Asunto<span class=" text-info"> (Opcional)</span> </label>
                            <textarea disabled id="asunto_documento" rows="3" class="form-control myi" style="resize:none;"
                                placeholder="Ingresar descripción para esta acción"></textarea>
                            <div class="sugerencias mt-2" id="sugerencias_asunto"></div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <label>Adjuntar documento (PDF)<span class=" text-info"> (Opcional)</span> </label>
                            <input id="archivo_documento" type="file" class="form-control" accept="application/pdf">
                        </div>
                    </div>
                    <label for="" class="text-dark">(<span class="text-danger">*</span>) Indica que los campos
                        son obligatorios</label>




                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                    <a href="javascript:;" id="atender" class="btn btn-success">Ejecutar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_finalizar_varios" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">FINALIZACIÓN MASIVA DE DOCUMENTOS</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="control-label">Tipo de documento <span class="text-danger">*</span></label>
                            <select class="form-select" id="tipo_documento_2">

                            </select>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Núm.<span class=" text-info"> (Opcional)</span> </label>
                            <input style="background-color: lemonchiffon" class="form-control " type="text"
                                id="numero_documento_2" placeholder="S/N">
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Folios<span class=" text-info"> (Opcional)</span> </label>
                            <input style="background-color: lemonchiffon" class="form-control" type="number"
                                id="folios_documento_2" placeholder="Páginas">
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>Cabecera del documento<span class=" text-info"> (Opcional)</span></label>
                            <input style="background-color: lemonchiffon" class="form-control myi" type="text"
                                id="cabecera_documento_2"
                                placeholder="Ejemplo: OFICIO Nº 037-2024-ME-DREP-UGEL-Y/DIES “DAC”-Q">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 mb-3" id="box_cargar_data" style="display: none">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="customCheck1_2">
                                <label class="custom-control-label text-indigo" for="customCheck1_2">Cargar datos del
                                    documento principal</label>
                            </div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label>Asunto<span class=" text-info"> (Opcional)</span> </label>
                            <textarea style="background-color: lemonchiffon" id="asunto_documento_2" rows="3" class="form-control myi"
                                style="resize:none;" placeholder="Ingresar descripción para esta acción"></textarea>
                            <div class="sugerencias mt-2" id="sugerencias_asunto_2"></div>

                        </div>
                    </div>
                    <label for="" class="text-dark">(<span class="text-danger">*</span>) Indica que los campos
                        son obligatorios</label>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                    <a href="javascript:;" id="finalizar_varios" class="btn btn-success">Finalizar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_archivar_varios" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">ARCHIVACIÓN MASIVA DE DOCUMENTOS</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">


                    <div class="row">
                        <div class="col-lg-12 mb-3" id="box_cargar_data" style="display: none">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="customCheck1_2">
                                <label class="custom-control-label text-indigo" for="customCheck1_2">Cargar datos del
                                    documento principal</label>
                            </div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label>Asunto<span class=" text-info"> (Opcional)</span> </label>
                            <textarea style="background-color: lemonchiffon" id="asunto_documento_3" rows="3" class="form-control myi"
                                style="resize:none;" placeholder="Ingresar descripción para esta acción"></textarea>
                            <div class="sugerencias mt-2" id="sugerencias_asunto_3"></div>

                        </div>
                    </div>
                    <label for="" class="text-dark">(<span class="text-danger">*</span>) Indica que los campos
                        son obligatorios</label>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                    <a href="javascript:;" id="archivar_varios" class="btn btn-success">Archivar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_derivar_varios">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">DERIVACIÓN MASIVA DE DOCUMENTOS</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-5 mb-3">
                            <label>Oficina destino <span class=" text-danger">*</span> </label>
                            <select class="form-select" id="destino_varios">

                            </select>
                        </div>
                        <div class="col-lg-7 mb-3">
                            <label>Destinatario <span class=" text-danger">*</span> </label>
                            <select class="form-select" id="empleado_varios">

                            </select>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="control-label">Tipo de documento <span class="text-danger">*</span></label>
                            <select class="form-select" id="tipo_documento_varios">

                            </select>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Núm.<span class=" text-info"> (Opcional)</span> </label>
                            <input style="background-color: lemonchiffon" class="form-control " type="text"
                                id="numero_documento_varios" placeholder="S/N">
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Folios<span class=" text-info"> (Opcional)</span> </label>
                            <input style="background-color: lemonchiffon" class="form-control" type="number"
                                id="folios_documento_varios" placeholder="Páginas">
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>Cabecera del documento<span class=" text-info"> (Opcional)</span></label>
                            <input style="background-color: lemonchiffon" class="form-control myi" type="text"
                                id="cabecera_documento_varios"
                                placeholder="Ejemplo: OFICIO Nº 037-2024-ME-DREP-UGEL-Y/DIES “DAC”-Q">
                        </div>
                    </div>
                    <div class="row">

                        <div class="col-lg-12 mb-3">
                            <label>Asunto<span class=" text-info"> (Opcional)</span> </label>
                            <textarea style="background-color: lemonchiffon" id="asunto_documento_varios" rows="3"
                                class="form-control myi" style="resize:none;" placeholder="Ingresar descripción para esta acción"></textarea>
                            <div class="sugerencias mt-2" id="sugerencias_asunto_varios"></div>

                        </div>
                    </div>
                    <label for="" class="text-dark">(<span class="text-danger">*</span>) Indica que los campos
                        son obligatorios</label>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                    <a href="javascript:;" id="derivar_varios" class="btn btn-success">Derivar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_remitente">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Datos del remitente</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="control-label">Tipo de persona <span class="text-danger"></span></label>
                            <div class="input-group">
                                <input id="tipo_persona" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>RUC<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="ruc" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>Razón social<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="razon" type="text" class="form-control" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6 mb-3">
                            <label>Documento de identidad<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="dni" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Nombres<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="nombre" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Apellido paterno<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="paterno" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Apellido materno<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="materno" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label>Dirección<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="direccion" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Correo electrónico<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="correo" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Teléfono / Celular<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="celular" type="text" class="form-control">
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->

    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_documento">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Datos del documento</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="control-label">Tipo de documento <span class="text-danger"></span></label>
                            <div class="input-group">
                                <input id="tipo_documento_mas" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Numero<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="numero_documento_mas" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Folios<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="folios_documento_mas" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>Cabecera<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="cabecera_documento_mas" type="text" class="form-control" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <span id="lbl_documento_mas"></span>
                            <iframe id="documento_doc_mas" width="100%" height="500" src=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_cargo">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Cargo</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">


                    <div class="row">
                        <div class="col-sm-12">

                            <iframe id="documento_doc_cargo" width="100%" height="500" src=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
    <!-- #modal-dialog -->
    <div class="modal fade " id="modal_tbl_ruta">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Trayectoria del expediente</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <table id="tabla_movimiento"
                                class="table table-striped table-bordered table-td-valign-middle">
                                <thead>
                                    <tr>
                                        <th width="1%">#</th>
                                        <th class="text-nowrap">Unidad Orgánica</th>
                                        <th class="text-nowrap">Responsable</th>
                                        <th class="text-nowrap">Nro Registro</th>
                                        <th class="text-nowrap">Año</th>
                                        <th class="text-nowrap">Estado</th>
                                        <th class="text-nowrap">Fecha</th>
                                        <th class="text-nowrap">Mas datos</th>
                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th width="1%">#</th>
                                        <th class="text-nowrap">Unidad Orgánica</th>
                                        <th class="text-nowrap">Responsable</th>
                                        <th class="text-nowrap">Nro Registro</th>
                                        <th class="text-nowrap">Año</th>
                                        <th class="text-nowrap">Estado</th>
                                        <th class="text-nowrap">Fecha</th>
                                        <th class="text-nowrap">Mas datos</th>
                                    </tr>
                                </tfoot>
                            </table>

                        </div>

                    </div>

                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->

    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_movimiento">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Datos del movimiento del expediente</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <ul class="nav nav-pills mb-2">
                        <li class="nav-item">
                            <a href="#nav-pills-tab-1" data-toggle="tab" class="nav-link active">
                                <span class="d-sm-none">Ver Información</span>
                                <span class="d-sm-block d-none">Ver Información</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#nav-pills-tab-2" data-toggle="tab" class="nav-link">
                                <span class="d-sm-none">Ver Documento</span>
                                <span class="d-sm-block d-none">Ver Documento</span>
                            </a>
                        </li>

                    </ul>
                    <div class="tab-content p-15 rounded bg-white mb-4">
                        <!-- begin tab-pane -->
                        <div class="tab-pane fade active show" id="nav-pills-tab-1">
                            <div class="row">
                                <div class="col-lg-4 mb-3">
                                    <label class="control-label">Tipo de documento <span
                                            class="text-danger"></span></label>
                                    <div class="input-group">
                                        <input id="tipo_documento_mov" type="text" class="form-control" disabled>
                                    </div>
                                </div>
                                <div class="col-lg-2 mb-3">
                                    <label>Numero<span class=" text-danger"></span> </label>
                                    <div class="input-group">
                                        <input id="numero_documento_mov" type="text" class="form-control" disabled>
                                    </div>
                                </div>
                                <div class="col-lg-2 mb-3">
                                    <label>Folios<span class=" text-danger"></span> </label>
                                    <div class="input-group">
                                        <input id="folios_documento_mov" type="text" class="form-control" disabled>
                                    </div>
                                </div>
                                <div class="col-lg-4 mb-3">
                                    <label>Cabecera<span class=" text-danger"></span> </label>
                                    <div class="input-group">
                                        <input id="cabecera_documento_mov" type="text" class="form-control" disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12 mb-3">
                                    <label>Asunto<span class=" text-danger"></span> </label>
                                    <textarea id="asunto_documento_mov" rows="3" class="form-control" style="resize:none;" disabled></textarea>

                                </div>
                            </div>
                        </div>
                        <!-- end tab-pane -->
                        <!-- begin tab-pane -->
                        <div class="tab-pane fade" id="nav-pills-tab-2">
                            <div class="row">
                                <div class="col-sm-12">
                                    <span id="lbl_documento_mov"></span>

                                    <iframe style="display: none" id="documento_doc_mov" width="100%" height="500"
                                        src=""></iframe>

                                </div>
                            </div>
                        </div>
                        <!-- end tab-pane -->
                        <!-- begin tab-pane -->

                    </div>

                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->

    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_ver_cargo">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Cargo de registro</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-sm-12">

                            <iframe id="documento_doc_cargo_or" width="100%" height="500" src=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
@endsection
@section('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('js/aceptados_externos.js') }}"></script>
    <script>
        $('#accion').select2({
            dropdownParent: '#modal_derivar_expediente',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#destino').select2({
            dropdownParent: '#modal_derivar_expediente',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#destino_varios').select2({
            dropdownParent: '#modal_derivar_varios',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#empleado').select2({
            dropdownParent: '#modal_derivar_expediente',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#empleado_varios').select2({
            dropdownParent: '#modal_derivar_varios',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#tipo_documento').select2({
            dropdownParent: '#modal_derivar_expediente',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#tipo_documento_varios').select2({
            dropdownParent: '#modal_derivar_varios',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#tipo_documento_2').select2({
            dropdownParent: '#modal_finalizar_varios',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#rol').select2({
            dropdownParent: '#modal_registrar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#oficina').select2({
            dropdownParent: '#modal_registrar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#empleado_edit').select2({
            dropdownParent: '#modal_editar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        });
        $('#rol_edit').select2({
            dropdownParent: '#modal_editar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        });
        $('#oficina_edit').select2({
            dropdownParent: '#modal_editar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        });

        $('#modal_derivar_expediente').on('hidden.bs.modal', function() {

            $('#accion').val('').trigger('change');
            $('#destino').val('').trigger('change').prop('disabled', true);
            $('#empleado').val('').trigger('change').prop('disabled', true);
            $('#tipo_documento').val('').trigger('change').prop('disabled', true);
            $('#numero_documento').val('').prop('disabled', true);
            $('#folios_documento').val('').prop('disabled', true);
            $('#cabecera_documento').val('').prop('disabled', true);
            $('#asunto_documento').val('');
            $('#archivo_documento').val('');
            $('#box_multiple').hide();
            $('#box_cargar_data').hide();
        });

        /*document.addEventListener('DOMContentLoaded', function() {
            var sugerenciasContainer = document.getElementById('sugerencias_asunto');
            var asuntoInput = document.getElementById('asunto_documento');
            var registrarButton = document.getElementById('atender');

            // Mostrar sugerencias mientras el usuario escribe
            asuntoInput.addEventListener('input', function() {
                mostrarSugerencias();
            });

            // Guardar el asunto al hacer clic en el botón "Registrar expediente"
            registrarButton.addEventListener('click', function() {
                guardarAsunto();
            });

            function mostrarSugerencias() {
                var asunto = asuntoInput.value.trim();
                sugerenciasContainer.innerHTML = ''; // Limpiar las sugerencias anteriores

                if (asunto !== '') {
                    // Obtener sugerencias guardadas del localStorage
                    var sugerenciasGuardadas = localStorage.getItem('sugerencias') ? JSON.parse(localStorage
                        .getItem('sugerencias')) : [];

                    // Filtrar sugerencias basadas en lo que el usuario ha escrito
                    var sugerenciasFiltradas = sugerenciasGuardadas.filter(function(sugerencia) {
                        return sugerencia.toLowerCase().includes(asunto.toLowerCase());
                    });

                    // Mostrar las sugerencias filtradas
                    sugerenciasFiltradas.forEach(function(sugerencia) {
                        var sugerenciaElement = document.createElement('a');
                        sugerenciaElement.textContent = sugerencia;
                        sugerenciaElement.classList.add('sugerencia');
                        sugerenciaElement.href = '#';
                        sugerenciaElement.addEventListener('click', function(event) {
                            event.preventDefault(); // Evitar que el hipervínculo redirija
                            asuntoInput.value = sugerencia;
                            sugerenciasContainer.style.display = 'none';
                        });
                        sugerenciasContainer.appendChild(sugerenciaElement);
                        sugerenciasContainer.appendChild(document.createElement(
                        'br')); // Añadir un salto de línea
                    });

                    // Mostrar el contenedor de sugerencias
                    sugerenciasContainer.style.display = 'block';
                } else {
                    // Ocultar el contenedor de sugerencias si el campo está vacío
                    sugerenciasContainer.style.display = 'none';
                }
            }

            function guardarAsunto() {
                var asunto = asuntoInput.value.trim();
                if (asunto !== '') {
                    // Obtener sugerencias guardadas anteriormente
                    var sugerenciasGuardadas = localStorage.getItem('sugerencias') ? JSON.parse(localStorage
                        .getItem('sugerencias')) : [];

                    // Verificar si el asunto ya existe en las sugerencias guardadas
                    if (!sugerenciasGuardadas.includes(asunto)) {
                        // Agregar el nuevo asunto a las sugerencias guardadas
                        sugerenciasGuardadas.push(asunto);
                        // Guardar las sugerencias actualizadas en el almacenamiento local
                        localStorage.setItem('sugerencias', JSON.stringify(sugerenciasGuardadas));
                    }
                }
            }
        });*/



        document.addEventListener('DOMContentLoaded', function() {
            function initializeSugerencias(asuntoInputId, sugerenciasContainerId, registrarButtonId) {
                var sugerenciasContainer = document.getElementById(sugerenciasContainerId);
                var asuntoInput = document.getElementById(asuntoInputId);
                var registrarButton = document.getElementById(registrarButtonId);

                // Mostrar sugerencias mientras el usuario escribe
                asuntoInput.addEventListener('input', function() {
                    mostrarSugerencias(asuntoInput, sugerenciasContainer);
                });

                // Guardar el asunto al hacer clic en el botón "Registrar expediente"
                registrarButton.addEventListener('click', function() {
                    guardarAsunto(asuntoInput);
                });
            }

            function mostrarSugerencias(asuntoInput, sugerenciasContainer) {
                var asunto = asuntoInput.value.trim();
                sugerenciasContainer.innerHTML = ''; // Limpiar las sugerencias anteriores

                if (asunto !== '') {
                    // Obtener sugerencias guardadas del localStorage
                    var sugerenciasGuardadas = localStorage.getItem('sugerencias') ? JSON.parse(localStorage
                        .getItem('sugerencias')) : [];

                    // Filtrar sugerencias basadas en lo que el usuario ha escrito
                    var sugerenciasFiltradas = sugerenciasGuardadas.filter(function(sugerencia) {
                        return sugerencia.toLowerCase().includes(asunto.toLowerCase());
                    });

                    // Mostrar las sugerencias filtradas
                    sugerenciasFiltradas.forEach(function(sugerencia) {
                        var sugerenciaElement = document.createElement('a');
                        sugerenciaElement.textContent = sugerencia;
                        sugerenciaElement.classList.add('sugerencia');
                        sugerenciaElement.href = '#';
                        sugerenciaElement.addEventListener('click', function(event) {
                            event.preventDefault(); // Evitar que el hipervínculo redirija
                            asuntoInput.value = sugerencia;
                            sugerenciasContainer.style.display = 'none';
                        });
                        sugerenciasContainer.appendChild(sugerenciaElement);
                        sugerenciasContainer.appendChild(document.createElement(
                        'br')); // Añadir un salto de línea
                    });

                    // Mostrar el contenedor de sugerencias
                    sugerenciasContainer.style.display = 'block';
                } else {
                    // Ocultar el contenedor de sugerencias si el campo está vacío
                    sugerenciasContainer.style.display = 'none';
                }
            }

            function guardarAsunto(asuntoInput) {
                var asunto = asuntoInput.value.trim();
                if (asunto !== '') {
                    // Obtener sugerencias guardadas anteriormente
                    var sugerenciasGuardadas = localStorage.getItem('sugerencias') ? JSON.parse(localStorage
                        .getItem('sugerencias')) : [];

                    // Verificar si el asunto ya existe en las sugerencias guardadas
                    if (!sugerenciasGuardadas.includes(asunto)) {
                        // Agregar el nuevo asunto a las sugerencias guardadas
                        sugerenciasGuardadas.push(asunto);
                        // Guardar las sugerencias actualizadas en el almacenamiento local
                        localStorage.setItem('sugerencias', JSON.stringify(sugerenciasGuardadas));
                    }
                }
            }

            // Inicializar sugerencias para cada modal
            initializeSugerencias('asunto_documento', 'sugerencias_asunto', 'atender');
            initializeSugerencias('asunto_documento_2', 'sugerencias_asunto_2', 'finalizar_varios');
            initializeSugerencias('asunto_documento_3', 'sugerencias_asunto_3', 'archivar_varios');
            initializeSugerencias('asunto_documento_varios', 'sugerencias_asunto_varios', 'derivar_varios');
        });
    </script>
@endsection
