<?php

/**
 * This file is part of the "laravel-lang/locales" project.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @author Andrey Helldar <helldar@dragon-code.pro>
 * @copyright 2023 Laravel Lang Team
 * @license MIT
 *
 * @see https://laravel-lang.com
 */

declare(strict_types=1);

use LaravelLang\Locales\Enums\Locale;

return [
    'map' => [
        Locale::Afrikaans->value => [
            'type'     => 'Latn',
            'name'     => 'Afrikaans',
            'native'   => 'Afrikaans',
            'regional' => 'af_ZA',
        ],

        Locale::Albanian->value => [
            'type'     => 'Latn',
            'name'     => 'Albanian',
            'native'   => 'shqip',
            'regional' => 'sq_AL',
        ],

        Locale::Arabic->value => [
            'type'     => 'Arab',
            'name'     => 'Arabic',
            'native'   => 'العربية',
            'regional' => 'ar_AE',
        ],

        Locale::Armenian->value => [
            'type'     => 'Armn',
            'name'     => 'Armenian',
            'native'   => 'Հայերեն',
            'regional' => 'hy_AM',
        ],

        Locale::Azerbaijani->value => [
            'type'     => 'Latn',
            'name'     => 'Azerbaijani (Latin)',
            'native'   => 'azərbaycanca',
            'regional' => 'az_AZ',
        ],

        Locale::Basque->value => [
            'type'     => 'Latn',
            'name'     => 'Basque',
            'native'   => 'euskara',
            'regional' => 'eu_ES',
        ],

        Locale::Belarusian->value => [
            'type'     => 'Cyrl',
            'name'     => 'Belarusian',
            'native'   => 'беларуская',
            'regional' => 'be_BY',
        ],

        Locale::Bengali->value => [
            'type'     => 'Beng',
            'name'     => 'Bengali',
            'native'   => 'বাংলা',
            'regional' => 'bn_BD',
        ],

        Locale::Bosnian->value => [
            'type'     => 'Latn',
            'name'     => 'Bosnian',
            'native'   => 'bosanski',
            'regional' => 'bs_BA',
        ],

        Locale::Bulgarian->value => [
            'type'     => 'Cyrl',
            'name'     => 'Bulgarian',
            'native'   => 'български',
            'regional' => 'bg_BG',
        ],

        Locale::Catalan->value => [
            'type'     => 'Latn',
            'name'     => 'Catalan',
            'native'   => 'català',
            'regional' => 'ca_ES',
        ],

        Locale::CentralKhmer->value => [
            'type'     => 'Khmr',
            'name'     => 'Khmer',
            'native'   => 'ភាសាខ្មែរ',
            'regional' => 'km_KH',
        ],

        Locale::Chinese->value => [
            'type'     => 'Hans',
            'name'     => 'Chinese (Simplified)',
            'native'   => '简体中文',
            'regional' => 'zh_CN',
        ],

        Locale::ChineseHongKong->value => [
            'type'     => 'Hans',
            'name'     => 'Chinese (Hong Kong)',
            'native'   => '简体中文',
            'regional' => 'zh_HK',
        ],

        Locale::ChineseT->value => [
            'type'     => 'Hans',
            'name'     => 'Chinese (Taiwan)',
            'native'   => '简体中文',
            'regional' => 'zh_TW',
        ],

        Locale::Croatian->value => [
            'type'     => 'Latn',
            'name'     => 'Croatian',
            'native'   => 'hrvatski',
            'regional' => 'hr_HR',
        ],

        Locale::Czech->value => [
            'type'     => 'Latn',
            'name'     => 'Czech',
            'native'   => 'čeština',
            'regional' => 'cs_CZ',
        ],

        Locale::Danish->value => [
            'type'     => 'Latn',
            'name'     => 'Danish',
            'native'   => 'dansk',
            'regional' => 'da_DK',
        ],

        Locale::Dutch->value => [
            'type'     => 'Latn',
            'name'     => 'Dutch',
            'native'   => 'Nederlands',
            'regional' => 'nl_NL',
        ],

        Locale::English->value => [
            'type'     => 'Latn',
            'name'     => 'English',
            'native'   => 'English',
            'regional' => 'en_GB',
        ],

        Locale::Estonian->value => [
            'type'     => 'Latn',
            'name'     => 'Estonian',
            'native'   => 'eesti',
            'regional' => 'et_EE',
        ],

        Locale::Finnish->value => [
            'type'     => 'Latn',
            'name'     => 'Finnish',
            'native'   => 'suomi',
            'regional' => 'fi_FI',
        ],

        Locale::French->value => [
            'type'     => 'Latn',
            'name'     => 'French',
            'native'   => 'français',
            'regional' => 'fr_FR',
        ],

        Locale::Galician->value => [
            'type'     => 'Latn',
            'name'     => 'Galician',
            'native'   => 'galego',
            'regional' => 'gl_ES',
        ],

        Locale::Georgian->value => [
            'type'     => 'Geor',
            'name'     => 'Georgian',
            'native'   => 'ქართული',
            'regional' => 'ka_GE',
        ],

        Locale::German->value => [
            'type'     => 'Latn',
            'name'     => 'German',
            'native'   => 'Deutsch',
            'regional' => 'de_DE',
        ],

        Locale::GermanSwitzerland->value => [
            'type'     => 'Latn',
            'name'     => 'Swiss High German',
            'native'   => 'Schweizer Hochdeutsch',
            'regional' => 'de_CH',
        ],

        Locale::Greek->value => [
            'type'     => 'Grek',
            'name'     => 'Greek',
            'native'   => 'Ελληνικά',
            'regional' => 'el_GR',
        ],

        Locale::Gujarati->value => [
            'type'     => 'Gujr',
            'name'     => 'Gujarati',
            'native'   => 'ગુજરાતી',
            'regional' => 'gu_IN',
        ],

        Locale::Hebrew->value => [
            'type'     => 'Hebr',
            'name'     => 'Hebrew',
            'native'   => 'עברית',
            'regional' => 'he_IL',
        ],

        Locale::Hindi->value => [
            'type'     => 'Deva',
            'name'     => 'Hindi',
            'native'   => 'हिन्दी',
            'regional' => 'hi_IN',
        ],

        Locale::Hungarian->value => [
            'type'     => 'Latn',
            'name'     => 'Hungarian',
            'native'   => 'magyar',
            'regional' => 'hu_HU',
        ],

        Locale::Icelandic->value => [
            'type'     => 'Latn',
            'name'     => 'Icelandic',
            'native'   => 'íslenska',
            'regional' => 'is_IS',
        ],

        Locale::Indonesian->value => [
            'type'     => 'Latn',
            'name'     => 'Indonesian',
            'native'   => 'Bahasa Indonesia',
            'regional' => 'id_ID',
        ],

        Locale::Italian->value => [
            'type'     => 'Latn',
            'name'     => 'Italian',
            'native'   => 'italiano',
            'regional' => 'it_IT',
        ],

        Locale::Japanese->value => [
            'type'     => 'Jpan',
            'name'     => 'Japanese',
            'native'   => '日本語',
            'regional' => 'ja_JP',
        ],

        Locale::Kannada->value => [
            'type'     => 'Knda',
            'name'     => 'Kannada',
            'native'   => 'ಕನ್ನಡ',
            'regional' => 'kn_IN',
        ],

        Locale::Kazakh->value => [
            'type'     => 'Cyrl',
            'name'     => 'Kazakh',
            'native'   => 'қазақ тілі',
            'regional' => 'kk_KZ',
        ],

        Locale::Korean->value => [
            'type'     => 'Hang',
            'name'     => 'Korean',
            'native'   => '한국어',
            'regional' => 'ko_KR',
        ],

        Locale::Latvian->value => [
            'type'     => 'Latn',
            'name'     => 'Latvian',
            'native'   => 'latviešu',
            'regional' => 'lv_LV',
        ],

        Locale::Lithuanian->value => [
            'type'     => 'Latn',
            'name'     => 'Lithuanian',
            'native'   => 'lietuvių',
            'regional' => 'lt_LT',
        ],

        Locale::Macedonian->value => [
            'type'     => 'Cyrl',
            'name'     => 'Macedonian',
            'native'   => 'македонски',
            'regional' => 'mk_MK',
        ],

        Locale::Malay->value => [
            'type'     => 'Latn',
            'name'     => 'Malay',
            'native'   => 'Bahasa Melayu',
            'regional' => 'ms_MY',
        ],

        Locale::Marathi->value => [
            'type'     => 'Deva',
            'name'     => 'Marathi',
            'native'   => 'मराठी',
            'regional' => 'mr_IN',
        ],

        Locale::Mongolian->value => [
            'type'     => 'Mong',
            'name'     => 'Mongolian',
            'native'   => 'ᠮᠣᠨᠭᠭᠣᠯ ᠬᠡᠯᠡ',
            'regional' => 'mn_MN',
        ],

        Locale::Nepali->value => [
            'type'   => 'Deva',
            'name'   => 'Nepali',
            'native' => 'नेपाली',
        ],

        Locale::NorwegianBokmal->value => [
            'type'     => 'Latn',
            'name'     => 'Norwegian Bokmål',
            'native'   => 'Bokmål',
            'regional' => 'nb_NO',
        ],

        Locale::NorwegianNynorsk->value => [
            'type'     => 'Latn',
            'name'     => 'Norwegian Nynorsk',
            'native'   => 'nynorsk',
            'regional' => 'nn_NO',
        ],

        Locale::Occitan->value => [
            'type'     => 'Latn',
            'name'     => 'Occitan',
            'native'   => 'occitan',
            'regional' => 'oc_FR',
        ],

        Locale::Pashto->value => [
            'type'     => 'Arab',
            'name'     => 'Pashto',
            'native'   => 'پښتو',
            'regional' => 'ps_AF',
        ],

        Locale::Persian->value => [
            'type'     => 'Arab',
            'name'     => 'Persian',
            'native'   => 'فارسی',
            'regional' => 'fa_IR',
        ],

        Locale::Pilipino->value => [
            'type'     => 'Latn',
            'name'     => 'Filipino',
            'native'   => 'Filipino',
            'regional' => 'fil_PH',
        ],

        Locale::Polish->value => [
            'type'     => 'Latn',
            'name'     => 'Polish',
            'native'   => 'polski',
            'regional' => 'pl_PL',
        ],

        Locale::Portuguese->value => [
            'type'     => 'Latn',
            'name'     => 'Portuguese',
            'native'   => 'português',
            'regional' => 'pt_PT',
        ],

        Locale::PortugueseBrazil->value => [
            'type'     => 'Latn',
            'name'     => 'Brazilian Portuguese',
            'native'   => 'português do Brasil',
            'regional' => 'pt_BR',
        ],

        Locale::Romanian->value => [
            'type'     => 'Latn',
            'name'     => 'Romanian',
            'native'   => 'română',
            'regional' => 'ro_RO',
        ],

        Locale::Russian->value => [
            'type'     => 'Cyrl',
            'name'     => 'Russian',
            'native'   => 'русский',
            'regional' => 'ru_RU',
        ],

        Locale::Sardinian->value => [
            'type'     => 'Latn',
            'name'     => 'Sardinian',
            'native'   => 'sardu',
            'regional' => 'sc_IT',
        ],

        Locale::SerbianCyrillic->value => [
            'type'     => 'Cyrl',
            'name'     => 'Serbian (Cyrillic)',
            'native'   => 'Српски',
            'regional' => 'sr_RS',
        ],

        Locale::SerbianLatin->value => [
            'type'     => 'Latn',
            'name'     => 'Serbian (Latin)',
            'native'   => 'Srpski',
            'regional' => 'sr_RS',
        ],

        Locale::SerbianMontenegrin->value => [
            'type'     => 'Latn',
            'name'     => 'Serbian (Montenegro)',
            'native'   => 'Serbian (Latin, Montenegro)',
            'regional' => 'sr_Latn_ME',
        ],

        Locale::Sinhala->value => [
            'type'     => 'Sinh',
            'name'     => 'Sinhala',
            'native'   => 'සිංහල',
            'regional' => 'si_LK',
        ],

        Locale::Slovak->value => [
            'type'     => 'Latn',
            'name'     => 'Slovak',
            'native'   => 'slovenčina',
            'regional' => 'sk_SK',
        ],

        Locale::Slovenian->value => [
            'type'     => 'Latn',
            'name'     => 'Slovene',
            'native'   => 'slovenščina',
            'regional' => 'sl_SI',
        ],

        Locale::Spanish->value => [
            'type'     => 'Latn',
            'name'     => 'Spanish',
            'native'   => 'español',
            'regional' => 'es_ES',
        ],

        Locale::Swahili->value => [
            'type'     => 'Latn',
            'name'     => 'Swahili',
            'native'   => 'Kiswahili',
            'regional' => 'sw_KE',
        ],

        Locale::Swedish->value => [
            'type'     => 'Latn',
            'name'     => 'Swedish',
            'native'   => 'svenska',
            'regional' => 'sv_SE',
        ],

        Locale::Tagalog->value => [
            'type'     => 'Latn',
            'name'     => 'Tagalog',
            'native'   => 'Tagalog',
            'regional' => 'tl_PH',
        ],

        Locale::Tajik->value => [
            'type'     => 'Cyrl',
            'name'     => 'Tajik (Cyrillic)',
            'native'   => 'тоҷикӣ',
            'regional' => 'tg_TJ',
        ],

        Locale::Thai->value => [
            'type'     => 'Thai',
            'name'     => 'Thai',
            'native'   => 'ไทย',
            'regional' => 'th_TH',
        ],

        Locale::Turkish->value => [
            'type'     => 'Latn',
            'name'     => 'Turkish',
            'native'   => 'Türkçe',
            'regional' => 'tr_TR',
        ],

        Locale::Turkmen->value => [
            'type'     => 'Cyrl',
            'name'     => 'Turkmen',
            'native'   => 'түркменче',
            'regional' => 'tk_TM',
        ],

        Locale::Uighur->value => [
            'type'     => 'Arab',
            'name'     => 'Uyghur',
            'native'   => 'ئۇيغۇرچە',
            'regional' => 'ug_CN',
        ],

        Locale::Ukrainian->value => [
            'type'     => 'Cyrl',
            'name'     => 'Ukrainian',
            'native'   => 'українська',
            'regional' => 'uk_UA',
        ],

        Locale::Urdu->value => [
            'type'     => 'Arab',
            'name'     => 'Urdu',
            'native'   => 'اردو',
            'regional' => 'ur_PK',
        ],

        Locale::UzbekCyrillic->value => [
            'type'     => 'Cyrl',
            'name'     => 'Uzbek (Cyrillic)',
            'native'   => 'Ўзбек',
            'regional' => 'uz_UZ',
        ],

        Locale::UzbekLatin->value => [
            'type'     => 'Latn',
            'name'     => 'Uzbek (Latin)',
            'native'   => 'oʼzbekcha',
            'regional' => 'uz_UZ',
        ],

        Locale::Vietnamese->value => [
            'type'     => 'Latn',
            'name'     => 'Vietnamese',
            'native'   => 'Tiếng Việt',
            'regional' => 'vi_VN',
        ],

        Locale::Welsh->value => [
            'type'     => 'Latn',
            'name'     => 'Welsh',
            'native'   => 'Cymraeg',
            'regional' => 'cy_GB',
        ],
    ],
];
